//-----------------------------------------------------------------------------
// Plugin: EFMENU
// @author: Stenblood
//
// Overrides all menus and prevents them from being opened
//


// Scene_MenuBase

var _Window_MenuCommand_addMainCommands = Window_MenuCommand.prototype.addMainCommands;
Window_MenuCommand.prototype.addMainCommands = function() {
  _Window_MenuCommand_addMainCommands.call(this);
  this.addCommand('Extra', 'extras');
};

var _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
Scene_Menu.prototype.createCommandWindow = function() {
  _Scene_Menu_createCommandWindow.call(this);
  this._commandWindow.setHandler('extras', this.commandExtras.bind(this));
};

Scene_Menu.prototype.commandExtras = function() {
  SceneManager.push(Scene_Extras);
};

function Scene_Extras() {
  this.initialize.apply(this, arguments);
}

Scene_Extras.prototype = Object.create(Scene_MenuBase.prototype);
Scene_Extras.prototype.constructor = Scene_Extras;

Scene_Extras.prototype.initialize = function() {
  Scene_MenuBase.prototype.initialize.call(this);
};

Scene_Extras.prototype.create = function() {
  Scene_MenuBase.prototype.create.call(this);
  this.createExtras();
};

Scene_Extras.prototype.createExtras = function() {
  var x = Graphics.width / 3;
  var y = Graphics.height / 3;

  var width = 100;
  var height = 100;
  var text = new PIXI.Text('Welcome to the Extras Menu!', {
    fontFamily: $gameSystem.mainFontFace(),
    fontSize: 28,
    fill: 0xffffff,
    align: 'left'
  });
  text.x = x;
  text.y = y;
  this._windowLayer.addChild(text);
};

Scene_Extras.prototype.createCommandWindow = function() {
  this._commandWindow = new Window_Command(this._commandWindowRect());
  this._commandWindow.setHandler('1', this.command1.bind(this));
  this._commandWindow.setHandler('2', this.command2.bind(this));
  this._commandWindow.setHandler('3', this.command3.bind(this));
  this._commandWindow.setup(['1', '2', '3']);
  this._commandWindow.refresh();
  this._commandWindow.deselect();
  this._commandWindow.setBackgroundType(0);
  this._commandWindow.opacity = 0;
  this.addWindow(this._commandWindow);
};

Scene_Extras.prototype.command1 = function() {
  console.log('You selected "1"');
};

Scene_Extras.prototype.command2 = function() {
  console.log('You selected "2"');
};

Scene_Extras.prototype.command3 = function() {
  console.log('You selected "3"');
};



